@ECHO OFF
REM Batch file for running beta_lockinfo once and exporting the result.
REM Parameters %1 = Server
REM            %2 = Database (default tempdb).
REM            %3 = SQL-login (default Windows auth)
REM            %4 = Password for SQL-login.

SETLOCAL

SET SERVER=%1
IF DEFINED SERVER GOTO MoveOn
ECHO No server specified. Cannot load beta_lockinfo.
EXIT /b 19

:MoveOn
SET DB=%2
IF NOT DEFINED DB SET DB=tempdb

SET USER=%3
SET PWD=%4
SET AUTH=-E
SET BCPAUTH=-T
IF DEFINED USER SET AUTH=-U %USER% -P %PWD%
IF DEFINED USER SET BCPAUTH=-U %USER% -P %PWD%

SQLCMD -I %AUTH% -S %SERVER% -d %DB% -i beta_lockinfo_2008.sql
SQLCMD %AUTH% -S %SERVER% -d %DB% -Q "EXEC beta_lockinfo @archivemode = 60"
BCP %DB%.guest.beta_lockinfo out beta_lockinfo.bcp -f beta_lockinfo_2008-14.fmt -S %SERVER% %BCPAUTH% -q

ENDLOCAL


