/*---------------------------------------------------------------------
 $Header: /Perl/OlleDB/connect.h 4     26-01-01 21:21 Sommar $

  Implements the connection routines on Win32::SqlServer.

  Copyright (c) 2004-2026   Erland Sommarskog

  $History: connect.h $
 * 
 * *****************  Version 4  *****************
 * User: Sommar       Date: 26-01-01   Time: 21:21
 * Updated in $/Perl/OlleDB
 * Added new connection attribute SQL_major which is the first number in
 * the version string - but which will be 100 if we are connected to
 * Azure. get_db_codepage has now been extended to get values from
 * serverproperty() and therefore been renamed to
 * get_sqlserver_properties, and it is now called from do_connect as well
 * as initbatch.
 * 
 * *****************  Version 3  *****************
 * User: Sommar       Date: 19-07-08   Time: 22:36
 * Updated in $/Perl/OlleDB
 * Added function to get SQL version and current database from the Init
 * object and call this on connect. When server is changed, we need to
 * forget SQL Server version, current database and the coepages has. Split
 * setup_sesion into setup_datasrc and setup_session. as the data source
 * is now set up in initbatch.
 * 
 * *****************  Version 2  *****************
 * User: Sommar       Date: 08-01-05   Time: 21:26
 * Updated in $/Perl/OlleDB
 * Moving the creation of the session pointer broke AutoConnect. The code
 * for AutoConnect is now in the connect module and be called from
 * executebatch or definetablecolumn.
 *
 * *****************  Version 1  *****************
 * User: Sommar       Date: 07-12-24   Time: 21:39
 * Created in $/Perl/OlleDB
  ---------------------------------------------------------------------*/


// Connect, called from $X->Connect() and $X->executebatch for autoconnect.
extern BOOL do_connect (SV    * olle_ptr,
                        BOOL    isautoconnect);

// This is $X->setloginproperty.
extern void setloginproperty(SV   * olle_ptr,
                             char * prop_name,
                             SV   * prop_value);

// Set properties about the server and the current database.
extern BOOL set_sqlserver_properties (SV * olle_ptr);               

// Sets up the session pointer..
extern BOOL setup_session(SV * olle_ptr);


// $X->disconncet
extern void disconnect(SV * olle_ptr);
