#---------------------------------------------------------------------
# $Header: /Perl/OlleDB/Win32-SqlServer-install.pl 26    25-12-24 23:32 Sommar $
#
# A simple script for installing a binary of Win32::SqlServer.
#
# $History: Win32-SqlServer-install.pl $
# 
# *****************  Version 26  *****************
# User: Sommar       Date: 25-12-24   Time: 23:32
# Updated in $/Perl/OlleDB
# Added Perl 5.42.
# 
# *****************  Version 25  *****************
# User: Sommar       Date: 24-11-18   Time: 23:47
# Updated in $/Perl/OlleDB
# Fixed typo.
# 
# *****************  Version 24  *****************
# User: Sommar       Date: 24-07-23   Time: 23:59
# Updated in $/Perl/OlleDB
# Updated for Win32::SqlServer 2.015.
# 
# *****************  Version 23  *****************
# User: Sommar       Date: 22-06-08   Time: 21:29
# Updated in $/Perl/OlleDB
# Updated for version 2.014.
# 
# *****************  Version 22  *****************
# User: Sommar       Date: 21-07-03   Time: 23:23
# Updated in $/Perl/OlleDB
# Updated which Perl versions we support.
# 
# *****************  Version 21  *****************
# User: Sommar       Date: 19-07-18   Time: 23:44
# Updated in $/Perl/OlleDB
# Fixed syntax error.
# 
# *****************  Version 20  *****************
# User: Sommar       Date: 19-07-16   Time: 22:35
# Updated in $/Perl/OlleDB
# Updated for Win32::SqlServer 2.012. And renamed.
# 
# *****************  Version 19  *****************
# User: Sommar       Date: 18-04-10   Time: 22:31
# Updated in $/Perl/OlleDB
# Fixed syntax error.
# 
# *****************  Version 18  *****************
# User: Sommar       Date: 18-04-09   Time: 22:42
# Updated in $/Perl/OlleDB
# Modified for the versions supported by Win32::SqlServer 2.011.
# 
# *****************  Version 17  *****************
# User: Sommar       Date: 16-07-13   Time: 14:13
# Updated in $/Perl/OlleDB
# Commas were missing.
# 
# *****************  Version 16  *****************
# User: Sommar       Date: 16-07-12   Time: 22:05
# Updated in $/Perl/OlleDB
# 
# *****************  Version 15  *****************
# User: Sommar       Date: 15-05-24   Time: 21:03
# Updated in $/Perl/OlleDB
# Added support for Perl 5.18 and 5.20 and dropped support for Perl 5.8
# and 5.10.
# 
# *****************  Version 14  *****************
# User: Sommar       Date: 12-08-18   Time: 22:06
# Updated in $/Perl/OlleDB
# Added support for Perl 5.16.
# 
# *****************  Version 13  *****************
# User: Sommar       Date: 11-08-08   Time: 21:22
# Updated in $/Perl/OlleDB
# Syntax error
# 
# *****************  Version 12  *****************
# User: Sommar       Date: 11-08-07   Time: 21:11
# Updated in $/Perl/OlleDB
# Added support for ActivePerl 14xx.
# 
# *****************  Version 11  *****************
# User: Sommar       Date: 10-10-29   Time: 16:15
# Updated in $/Perl/OlleDB
# There is now also a binary for Perl 5.12.
#
# *****************  Version 10  *****************
# User: Sommar       Date: 08-05-04   Time: 15:28
# Updated in $/Perl/OlleDB
# Added Perl 5.10.
#
# *****************  Version 9  *****************
# User: Sommar       Date: 07-07-10   Time: 21:47
# Updated in $/Perl/OlleDB
# Added support for different architectures.
#
# *****************  Version 8  *****************
# User: Sommar       Date: 06-11-20   Time: 22:14
# Updated in $/Perl/OlleDB
# Use File::Path::mkpath instead of mkdir, to make sure that intermediate
# directories on the path are created as well.
#
# *****************  Version 7  *****************
# User: Sommar       Date: 06-04-17   Time: 21:17
# Updated in $/Perl/OlleDB
# No more MSVCR70, as it is statically linked.
#
# *****************  Version 6  *****************
# User: Sommar       Date: 05-11-27   Time: 17:10
# Updated in $/Perl/OlleDB
# En akutfall av fel accent.
#
# *****************  Version 5  *****************
# User: Sommar       Date: 05-11-26   Time: 23:47
# Updated in $/Perl/OlleDB
# Renamed the module to Win32::SqlServer and advanced to version 2.001.
#
# *****************  Version 4  *****************
# User: Sommar       Date: 05-11-13   Time: 17:22
# Updated in $/Perl/OlleDB
#
# *****************  Version 3  *****************
# User: Sommar       Date: 05-11-13   Time: 16:51
# Updated in $/Perl/OlleDB
#
# *****************  Version 2  *****************
# User: Sommar       Date: 05-11-13   Time: 16:32
# Updated in $/Perl/OlleDB
#
# *****************  Version 1  *****************
# User: Sommar       Date: 05-11-12   Time: 21:55
# Created in $/Perl/OlleDB
#---------------------------------------------------------------------

use strict;
use Config;
use File::Copy;
use File::Path;

sub makedir {
    my($dir) = @_;
    mkpath $dir, 0, 0755;
    if (not -d $dir) {
       die "Failed to create '$dir': $!\n";
    }
}

sub do_copy{
   my($src, $dest) = @_;
   if (-e $dest) {
      system(qq!attrib -r "$dest"!);
      unlink($dest);
   }
   print "Copying $src to $dest\n";
   copy($src, $dest) or die "Could not copy $src: $!\n";
   system(qq!attrib +r "$dest"!);
}

my $perltop = shift(@ARGV);
if (not $perltop) {
   $perltop = $^X;
   if ($perltop =~ /\\/) {
      my @perltop = split(/\\/, $perltop);
      pop(@perltop);
      pop(@perltop);
      $perltop = join('\\', @perltop);
   }
   else {
      my @PATH = split(/;/, $ENV{'PATH'});
      my $progname = $perltop;
      $progname = "$progname.EXE" unless $progname =~ /.exe$/i;
      undef $perltop;
      while (@PATH) {
         if (-e "$PATH[0]\\$progname") {
            $perltop = $PATH[0];
            my @perltop = split(/\\/, $perltop);
            pop(@perltop);
            $perltop = join('\\', @perltop);
            last;
         }
         shift @PATH;
      }
   }
}

my $ver = substr($], 0, 5);

if (not (grep ($_ == $ver, (5.032, 5.034, 5.036, 5.038, 5.040, 5.042)))) {
   print "You have Perl version $ver, but this install kit includes only binaries\n";
   print "for Perl 5.32, 5.34, 5.36, 5.38, 5.40 and 5.42.";
   print "You will need to install from sources. See README.html.\n";
   exit 245;
}

# Get the architecture.
my $arch = (split(/-/, $Config{'archname'}))[1];
if ($arch eq 'x64')  {
   $arch = 'AMD64';
}
elsif ($arch eq 'x86') {
   if (not $Config{'use64bitint'}) {
      print "You have 32-bit Perl version built *without* USE_64_BIT_INT.\n";
      print "This kit does only include binaries with 64-bit integers.\n";
      print "Please contact me, if you desperately need a binary.\n";
      exit 237;
   }
}
else {
   print "You architeture is $Config{'archname'}, and there is no binary\n";
   print "for this architecure. You have to build from sources. See README.html.\n"; 
   print "Beware that this module only runs on Windows.\n";
   exit 246;
}

print "Installing Win32::SqlServer in $perltop\n";

my $libdir  = "$perltop\\site\\lib\\Win32";
my $htmldir = "$perltop\\html\\site\\lib\\Win32";
my $autodir = "$perltop\\site\\lib\\auto\\Win32";
makedir($libdir);
makedir($htmldir);
makedir($autodir);
makedir("$autodir\\SqlServer");

do_copy("blib\\arch\\auto\\Win32\\SqlServer\\SqlServer-$arch-$ver.dll",
        "$autodir\\SqlServer\\SqlServer.dll");

do_copy('SqlServer.pm', "$libdir\\SqlServer.pm");

do_copy('Win32-SqlServer.html', "$htmldir\\SqlServer.html");

