/*---------------------------------------------------------------------
 $Header: /Perl/OlleDB/senddata.h 6     26-01-01 21:21 Sommar $

  Implements the routines for sending data and command to SQL Server:
  initbatch, enterparameter and executebatch, including routines to
  convert from Perl variables to SQL Server data types, save datetime
  data; those are in datetime.cpp.

  Copyright (c) 2004-2026   Erland Sommarskog

  $History: senddata.h $
 * 
 * *****************  Version 6  *****************
 * User: Sommar       Date: 26-01-01   Time: 21:21
 * Updated in $/Perl/OlleDB
 * Added new connection attribute SQL_major which is the first number in
 * the version string - but which will be 100 if we are connected to
 * Azure. get_db_codepage has now been extended to get values from
 * serverproperty() and therefore been renamed to
 * get_sqlserver_properties, and it is now called from do_connect as well
 * as initbatch.
 * 
 * *****************  Version 5  *****************
 * User: Sommar       Date: 19-07-08   Time: 22:43
 * Updated in $/Perl/OlleDB
 * Removed some functions that are only used internally. initbatch can no
 * return TRUE/FALSE.
 * 
 * *****************  Version 4  *****************
 * User: Sommar       Date: 11-08-07   Time: 23:29
 * Updated in $/Perl/OlleDB
 * Suppress warnings about data truncation on x64.
 * 
 * *****************  Version 3  *****************
 * User: Sommar       Date: 08-04-28   Time: 23:12
 * Updated in $/Perl/OlleDB
 * maxlen was incorrectly ULONG or UINT when it should have been DBLENGTH.
 *
 * *****************  Version 2  *****************
 * User: Sommar       Date: 08-01-06   Time: 18:56
 * Updated in $/Perl/OlleDB
 * All the switch(datatype) for parameters and column in TVPs are now in
 * common code, and not duplicated in senddata and tableparam.
 *
 * *****************  Version 1  *****************
 * User: Sommar       Date: 07-12-24   Time: 21:39
 * Created in $/Perl/OlleDB
  ---------------------------------------------------------------------*/


extern BOOL SV_to_binary (SV        * sv,
                          bin_options optBinaryAsStr,
                          BOOL        istimestamp,
                          BYTE      * &binaryval,
                          DBLENGTH    &value_len);

extern BOOL SV_to_ssvariant (SV          * sv,
                             SSVARIANT     &variant,
                             SV          * olle_ptr,
                             provider_enum provider,
                             void        * &save_str,
                             BSTR          &save_bstr);

extern void complete_binding (DBTYPE           datatype,
                              const char     * nameoftype,
                              DBLENGTH         maxlen,
                              SV             * sv_scale,
                              SV             * sv_precision,
                              size_t          &size_buffer,
                              DBBINDING       * binding,
                              DBPARAMBINDINFO * param_info);

BOOL perl_to_sqlvalue(SV         * olle_ptr,
                      SV         * sv_value,
                      DBTYPE       typeind,
                      WCHAR      * param_name,
                      WCHAR      * nameoftype,
                      DBBINDING  * binding,
                      DBLENGTH     maxlen,
                      valueunion  &sqlvalue,
                      DBLENGTH    &value_len,
                      void      * &save_ptr,
                      BSTR        &save_bstr);


void write_to_databuffer(SV           * olle_ptr,
                         BYTE         * buffer,
                         DBBYTEOFFSET   offset,
                         DBTYPE         typeind,
                         valueunion     value);


extern int initbatch(SV   *  olle_ptr,
                     SV   *  sv_cmdtext);

extern int enterparameter(SV   * olle_ptr,
                          SV   * sv_nameoftype,
                          SV   * sv_maxlen,
                          SV   * paramname,
                          BOOL   isinput,
                          BOOL   isoutput,
                          SV   * sv_value,
                          SV   * sv_precision,
                          SV   * sv_scale,
                          SV   * typeinfo);

extern int executebatch(SV   *olle_ptr,
                        SV   *sv_rows_affected);

