/*---------------------------------------------------------------------
  $Header: /AbaPerls/Doc/HTML/insfilgen-example/sql/SP/funset_install_sp.sp 1     02-07-02 21:46 Sommar $

  $History: funset_install_sp.sp $
 * 
 * *****************  Version 1  *****************
 * User: Sommar       Date: 02-07-02   Time: 21:46
 * Created in $/AbaPerls/Doc/HTML/insfilgen-example/sql/SP
  ---------------------------------------------------------------------*/

CREATE PROCEDURE funset_install_sp @functionid  int,
                                   @setting     varchar(15),
                                   @intvalue    int = NULL,
                                   @charvalue   char(3) = NULL,
                                   @delflag     bit = 0 AS

DECLARE @err   int,
        @msg   varchar(255)

BEGIN TRANSACTION

IF @delflag = 1
BEGIN
   SELECT @msg = 'Deleting setting ' + @setting + ' for function ' +
                  ltrim(str(@functionid))
   PRINT @msg

   DELETE functionsettings
   WHERE  functionid = @functionid
     AND  setting    = @setting
   SELECT @err = @@error IF @err <> 0 BEGIN ROLLBACK TRANSACTION RETURN @err END
END
ELSE IF NOT EXISTS (SELECT *
                    FROM   functionsettings
                    WHERE  functionid = @functionid
                      AND  setting    = @setting)
BEGIN
   IF EXISTS (SELECT * FROM functions WHERE functionid = @functionid)
   BEGIN
      SELECT @msg = 'Adding setting ' + @setting + ' for function ' +
                     ltrim(str(@functionid))
      PRINT @msg

      INSERT functionsettings (functionid, setting, intvalue, charvalue)
         VALUES (@functionid, @setting, @intvalue, @charvalue)
      SELECT @err = @@error IF @err <> 0 BEGIN ROLLBACK TRANSACTION RETURN @err END
   END
   ELSE
   BEGIN
      SELECT @msg = 'Not install setting ' + @setting +
                    ' for absent function ' + ltrim(str(@functionid))
      PRINT @msg
   END
END
-- There is no UPDATE branch here, as there is nothing to update. The
-- intvalue and charvalue columns are set per customer-site in
-- funset_set_value_sp.


COMMIT TRANSACTION
