/*---------------------------------------------------------------------
  $Header: /AbaPerls/Doc/HTML/insfilgen-example/sql/SP/fun_install_sp.sp 1     02-07-02 21:46 Sommar $

  $History: fun_install_sp.sp $
 * 
 * *****************  Version 1  *****************
 * User: Sommar       Date: 02-07-02   Time: 21:46
 * Created in $/AbaPerls/Doc/HTML/insfilgen-example/sql/SP
  ---------------------------------------------------------------------*/

CREATE PROCEDURE fun_install_sp @functionid   int,
                                @functionname varchar(50),
                                @extfile      varchar(255) = NULL AS

DECLARE @err   int,
        @msg   varchar(255)

BEGIN TRANSACTION

IF NOT EXISTS (SELECT * FROM functions WHERE functionid = @functionid)
BEGIN
   SELECT @msg = 'Adding function ' + ltrim(str(@functionid)) + ', ' +
                 @functionname
   PRINT @msg
   INSERT functions (functionid, functionname, extfile)
      VALUES (@functionid, @functionname, @extfile)
   SELECT @err = @@error IF @err <> 0 BEGIN ROLLBACK TRANSACTION RETURN @err END
END
ELSE
BEGIN
   SELECT @msg = 'Updating function ' + ltrim(str(@functionid)) + ', ' +
                 @functionname
   UPDATE functions
   SET    functionname = @functionname,
          extfile      = @extfile
   WHERE  functionid = @functionid
   SELECT @err = @@error IF @err <> 0 BEGIN ROLLBACK TRANSACTION RETURN @err END
END

COMMIT TRANSACTION
